#!/usr/bin/env bash

. .raptor/global.sh || exit 1


if [  $# -le 0 ]
then
	echo $cyan"Install a Flexi Block from the library"$white
    echo "install-flexi-block <flexi-block-library-id>"
    exit 1
fi


# Flexi Block Library ID
REQ_BLOCK_ID=$1
LIBRARY_DIR=$HOME/.raptor/flexi-block-library
FLEXI_BLOCK_DIR=$LIBRARY_DIR/$REQ_BLOCK_ID
# Path to the WordPress theme directory
WP_THEME_DIR=wp-content/themes/raptor-frontend


append_empty_lines() {
    echo "" >> $1
    echo "" >> $1
}

display_message() {
    echo $cyan"$1"$white
}

display_error() {
    echo $red"Error: $1"$white
}

display_success() {
    echo $green"Success: $1"$white
}

# Check library is installed in ~/.raptor
if [ ! -e $LIBRARY_DIR ]
then
    display_error "Error: Flexi Block Library not installed."
    exit 1
fi

# Check block exists in library
if [ ! -e $FLEXI_BLOCK_DIR ]
then
    display_error "Flexi Block '$REQ_BLOCK_ID' does not exist."
    exit 1
fi

# Check blocks directory exists
if [[ ! -e "$WP_THEME_DIR"/blocks ]]
then
    mkdir "$WP_THEME_DIR"/blocks
    mkdir "$WP_THEME_DIR"/src/scss/blocks
fi

# Check if block already exists in theme
if [ -e $WP_THEME_DIR"/blocks/"$REQ_BLOCK_ID".php" ]
then
    display_error "Flexi Block '$REQ_BLOCK_ID' already exists."
    exit 1
fi


cp $FLEXI_BLOCK_DIR/template.php $WP_THEME_DIR/blocks/"$REQ_BLOCK_ID".php
cp $FLEXI_BLOCK_DIR/style.scss $WP_THEME_DIR/src/scss/blocks/_"$REQ_BLOCK_ID".scss

sed -i '' -e '/^\/\/  Blocks/a\
@import "blocks/'$REQ_BLOCK_ID'";' $WP_THEME_DIR/src/scss/main.scss

append_empty_lines $WP_THEME_DIR/acf/blocks/blocks.php
tail -n +5 $FLEXI_BLOCK_DIR/acf.php >> $WP_THEME_DIR/acf/blocks/blocks.php

# Add to theme `functions.php` if file exists.
if [ -e $FLEXI_BLOCK_DIR/functions.php ]
then
    append_empty_lines $WP_THEME_DIR/functions.php
    tail -n +2 $FLEXI_BLOCK_DIR/functions.php >> $WP_THEME_DIR/functions.php

    display_message "Added to functions.php"
fi

if [ -e $FLEXI_BLOCK_DIR/*.js ]
then
    # Find the script filename then check it exists in the WP theme.
    SCRIPT_FILE_NAME=$(find $FLEXI_BLOCK_DIR -iname *.js | sed -E 's/.*\/([a-z]+\.js)$/\1/g')

    if [ -e $WP_THEME_DIR/src/js/frontend/$SCRIPT_FILE_NAME ]
    then
        append_empty_lines $WP_THEME_DIR/src/js/frontend/$SCRIPT_FILE_NAME
        cat $FLEXI_BLOCK_DIR/$SCRIPT_FILE_NAME >> $WP_THEME_DIR/src/js/frontend/$SCRIPT_FILE_NAME

        display_message "Added to $SCRIPT_FILE_NAME"
    fi
fi

display_success "Added '$REQ_BLOCK_ID' Flexi Block"
