#!/usr/bin/env bash

. .raptor/global.sh || exit 1

echo $cyan'Preparing to fetch site...'$white

TARGET="staging"

REMOTE_LOCATION=$(get_host $TARGET)
SQL_EXPORT_FILE="fetch-env.sql"


ssh $(get_host $TARGET "root") "
    cd $( echo "$STAGING_PATH" );
    wp db export $( echo "$SQL_EXPORT_FILE" );
"

echo "Downloading all files..."
rsync -avz "$REMOTE_LOCATION"/ ./

# Setup DB credentials
DB_NAME=$BARE_DOMAIN

if [ -z "$DB_NAME" ]; then
    DB_NAME=$(basename $(pwd) | tr '.' '-')
fi


echo "Setting wp-config.php constants"
wp config set DB_NAME "dev_"$DB_NAME
wp config set DB_USER $DB_USER
wp config set DB_PASSWORD $DB_PASSWORD
wp config set DB_HOST $DB_HOST
wp config set WP_ENVIRONMENT_TYPE "development"

# Create DB and import
wp db create
wp db import $SQL_EXPORT_FILE

# Clean up, remove exported SQL file.
rm $SQL_EXPORT_FILE

ssh $(get_host $TARGET "root") "
    cd $( echo "$STAGING_PATH" );
    rm $( echo "$SQL_EXPORT_FILE" );
"

# Use sync-db to get database setuo correctly.
.raptor/commands/sync-db.sh staging dev
