<?php
/**
 * Components
 */

/**  
 *  Pagination wherever it is needed
 *
 *  @since 1.0
 */
function raptor_pagination() {
    global $wp_query;

    $big = 999999999; // This needs to be an unlikely integer
    // For more options and info view the docs for paginate_links()
    // http://codex.wordpress.org/Function_Reference/paginate_links

    $links_args = [
        'base'      => str_replace( $big, '%#%', html_entity_decode( get_pagenum_link( $big ) ) ),
        'current'   => max( 1, get_query_var( 'paged' ) ),
        'total'     => $wp_query->max_num_pages,
        'mid_size'  => 5,
        'type'      => 'array',
        'prev_next' => true,
        'prev_text' => '
        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#000000"><path d="M9.7,18.3L9.7,18.3c0.39-0.39,0.39-1.02,0-1.41L5.83,13H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H5.83l3.88-3.88 c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0L2.7,11.3c-0.39,0.39-0.39,1.02,0,1.41l5.59,5.59 C8.68,18.68,9.32,18.68,9.7,18.3z"/></svg>',
        'next_text' => '
        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#000000"><path d="M14.29,5.71L14.29,5.71c-0.39,0.39-0.39,1.02,0,1.41L18.17,11H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h15.18l-3.88,3.88 c-0.39,0.39-0.39,1.02,0,1.41l0,0c0.39,0.39,1.02,0.39,1.41,0l5.59-5.59c0.39-0.39,0.39-1.02,0-1.41L15.7,5.71 C15.32,5.32,14.68,5.32,14.29,5.71z"/></svg>'
    ];

    $links_args = apply_filters( 'raptor_pagination_links', $links_args );

    // phpcs:disable PEAR.Functions.FunctionCallSignature
    $links = paginate_links($links_args);
    // phpcs:enable PEAR.Functions.FunctionCallSignature

    if ( $links ) {
        echo '<div class="pagination">';
        echo '<ul>';

        foreach ( $links as $link ) {
            printf( '<li>%s</li>', preg_replace( '/\/page\/1(\/?)\"/', '\1"', $link ) );
        }

        echo '</ul>';
        echo '</div>';
    }
}


/**
 * Global wrapper function to breadcrumbs from any provider.
 * 
 * @param bool $echo Should function echo or return output
 * @return string
 */
function raptor_breadcrumb( bool $echo = true ) {
    $found_provider = false;

    ob_start();
    echo '<div class="site-breadcrumb">';

    // Yoast
    if ( function_exists( 'yoast_breadcrumb' ) ) {
        yoast_breadcrumb();

        $found_provider = true;
    }

    // Rank Math
    if ( function_exists( 'rank_math_the_breadcrumbs' ) ) {
        rank_math_the_breadcrumbs();

        $found_provider = true;
    }

    echo '</div>';

    $output = ob_get_clean();

    if ( $found_provider && $echo ) {
        echo $output;
    }

    return $output;
}

/**
 * Display the social links set via Yoast SEO.
 * 
 * @param array $socials Get only specified socials.
 * @param string $format Possible values: icon, array
 */
function raptor_social_media_links( array $socials = [], string $format = 'icon' ) {

    $allowed_socials = [
        'facebook'  => [
            'yoast_key' => 'facebook_site',
            'prepend'   => '',
            'svg'       => '<svg xmlns="http://www.w3.org/2000/svg" width="11.44" height="22.187" viewBox="0 0 11.44 22.187"><path d="M3.324,22.186V12.263H0V8.32H3.324V5.213C3.324,1.837,5.386,0,8.4,0A27.9,27.9,0,0,1,11.44.156V3.683H9.351c-1.638,0-1.954.78-1.954,1.92V8.32h3.7l-.507,3.943H7.4v9.923" /></svg>'
        ],
        'instagram' => [
            'yoast_key' => 'instagram_url',
            'prepend'   => '',
            'svg'       => '<svg xmlns="http://www.w3.org/2000/svg" width="16.471" height="16.468" viewBox="0 0 16.471 16.468"><path d="M8.163,35.837a4.222,4.222,0,1,0,4.222,4.222A4.215,4.215,0,0,0,8.163,35.837Zm0,6.967a2.745,2.745,0,1,1,2.745-2.745A2.75,2.75,0,0,1,8.163,42.8Zm5.38-7.14a.985.985,0,1,1-.985-.985A.983.983,0,0,1,13.542,35.664Zm2.8,1a4.873,4.873,0,0,0-1.33-3.45,4.906,4.906,0,0,0-3.45-1.33c-1.36-.077-5.435-.077-6.794,0a4.9,4.9,0,0,0-3.45,1.327,4.889,4.889,0,0,0-1.33,3.45c-.077,1.36-.077,5.435,0,6.794a4.874,4.874,0,0,0,1.33,3.45,4.912,4.912,0,0,0,3.45,1.33c1.36.077,5.435.077,6.794,0a4.874,4.874,0,0,0,3.45-1.33,4.906,4.906,0,0,0,1.33-3.45C16.416,42.095,16.416,38.023,16.339,36.664Zm-1.756,8.25a2.779,2.779,0,0,1-1.565,1.565c-1.084.43-3.656.331-4.854.331s-3.774.1-4.854-.331a2.779,2.779,0,0,1-1.565-1.565c-.43-1.084-.331-3.656-.331-4.854s-.1-3.774.331-4.854a2.779,2.779,0,0,1,1.565-1.565c1.084-.43,3.656-.331,4.854-.331s3.774-.1,4.854.331A2.779,2.779,0,0,1,14.582,35.2c.43,1.084.331,3.656.331,4.854S15.012,43.833,14.582,44.913Z" transform="translate(0.075 -31.825)" /></svg>'
        ],
        'twitter'   => [
            'yoast_key' => 'twitter_site',
            'prepend'   => 'https://twitter.com/',
            'svg'       => '<svg xmlns="http://www.w3.org/2000/svg" width="27.946" height="22.697" viewBox="0 0 27.946 22.697"><path d="M25.073,53.738c.018.248.018.5.018.745,0,7.572-5.763,16.3-16.3,16.3A16.185,16.185,0,0,1,0,68.208a11.847,11.847,0,0,0,1.383.071,11.47,11.47,0,0,0,7.111-2.447A5.738,5.738,0,0,1,3.139,61.86a7.223,7.223,0,0,0,1.082.089,6.057,6.057,0,0,0,1.507-.2,5.728,5.728,0,0,1-4.593-5.621v-.071a5.768,5.768,0,0,0,2.589.727,5.736,5.736,0,0,1-1.773-7.66A16.28,16.28,0,0,0,13.76,55.122a6.466,6.466,0,0,1-.142-1.312,5.733,5.733,0,0,1,9.912-3.919,11.276,11.276,0,0,0,3.635-1.383,5.712,5.712,0,0,1-2.518,3.156,11.482,11.482,0,0,0,3.3-.887,12.312,12.312,0,0,1-2.873,2.961Z" transform="translate(0 -48.082)" /></svg>'
        ],
        'youtube'   => [
            'yoast_key' => 'youtube_url',
            'prepend'   => '',
            'svg'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"/></svg>'
        ],
        'linkedin'  => [
            'yoast_key' => 'linkedin_url',
            'prepend'   => '',
            'svg'       => '<svg xmlns="http://www.w3.org/2000/svg" width="21.653" height="21.648" viewBox="0 0 21.653 21.648"><path d="M4.847,53.648H.358V39.2H4.847ZM2.6,37.224A2.612,2.612,0,1,1,5.2,34.6,2.621,2.621,0,0,1,2.6,37.224ZM21.648,53.648H17.169V46.612c0-1.677-.034-3.827-2.334-3.827-2.334,0-2.692,1.822-2.692,3.706v7.156H7.659V39.2h4.305v1.972h.063a4.717,4.717,0,0,1,4.247-2.334c4.542,0,5.378,2.991,5.378,6.876v7.939Z" transform="translate(0 -32)" /></svg>'
        ]
    ];

    /**
     * Filters the allowed social media platforms
     * 
     * @param array $allowed_socials
     */
    $allowed_socials = apply_filters( 'raptor_social_media_allowed', $allowed_socials );

    $social_links = [];

    /**
     * Ckeck if using Yoast SEO.
     */
    $using_yoast = is_plugin_active( 'wordpress-seo/wp-seo.php' );

    if ( $using_yoast ) {
        $socials = get_option( 'wpseo_social' );
    } else {
        $socials = raptor_get_settings( 'raptor', 'social_media' );
    }

    foreach ( $allowed_socials as $social => $options ) {
        $url = !empty( $socials[ $social ] ) ? $socials[ $social ] : false;

        if ( $using_yoast ) {
            $url = !empty( $socials[ $options['yoast_key'] ] ) ? $socials[ $options['yoast_key'] ] : false;
        }

        if ( $url ) {
            if ( !empty( $options['prepend'] ) ) {
                $url = $options['prepend'] . $url;
            }

            $label = 'See us on ' . $social;

            if ( $format == 'array' ) {
                $social_links[ $social ] = $url;

            } else {
                $social_links[] = sprintf( '<a href="%s" class="social-link %s" aria-label="%s" target="_blank">%s</a>', $url, $social, $label, $options['svg'] );
            }
        }
    }

    if ( $format == 'array' ) {
        return $social_links;
    }

    printf( '<div class="social-media-links">%s</div>', implode( '', $social_links ) );
}

/**
 * Displays the built-in Announcement Bar component.
 */
function raptor_announcement_bar() {
    $announcement_bar = raptor_get_settings( 'raptor', 'announcement_bar' );

    if ( !$announcement_bar ) {
        return;
    }

    if ( is_front_page() && $announcement_bar && $announcement_bar['message'] ) :
        ?>
<div class="announcement-bar">
    <p>
        <?php
        if ( $announcement_bar['link'] ) {
            printf( '<a href="%s">%s</a>', $announcement_bar['link'], $announcement_bar['message'] );
        } else {
            echo $announcement_bar['message'];
        }
        ?>
    </p>
</div>
    <?php endif;
}



function raptor_green_hosting_badge() {
    ?>
<a href="https://www.boxchilli.com" class="raptor-green-hosting-badge">
    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 77.7 52" width="100" style="enable-background:new 0 0 77.7 52;" xml:space="preserve" fill="var(--r-ghb-primary,#34A12E)">
        <path d="M66.1,7.1c0-0.6-0.5-1.1-1.1-1.1c-0.6,0-1.1,0.5-1.1,1.1V17h2.3V7.1z"/>
        <path d="M73.3,8.7c0-0.6-0.5-1.1-1.1-1.1h-1.6c-0.6,0-1.1,0.5-1.1,1.1v8.4h3.8V8.7z"/>
        <path d="M56.6,17.1h3.8V8.7c0-0.6-0.5-1.1-1.1-1.1h-1.6c-0.6,0-1.1,0.5-1.1,1.1V17.1z"/>
        <path d="M76.8,18.2H53.1c-0.5,0-0.9,0.4-0.9,0.9v2.8c0,0.5,0.4,0.9,0.9,0.9h1.1v7.6v0.9c0,1,0.8,1.7,1.7,1.7c1.5,0,2.8,1.2,2.8,2.8v3.4c0,1,0.8,1.7,1.7,1.7h2.1c-4,5-10.1,8.1-16.9,8.1c-2.5,0-4.9-0.4-7.1-1.2c-5-6.9,2.9-18.6,2.9-18.6s-5.1,9.6-0.7,18.3c0,0,2.9,0.2,5.2-5c2.2-6.5-3.2-9.4-3.1-14.5c0-0.6-0.6-0.9-1.1-0.6c-10.7,8.3-8.2,16.7-7.6,18.4C28,41.9,23.9,35.1,23.9,27.3c0-1.3,0.1-2.5,0.3-3.7h0c2.1-14.1,15.7-21,15.7-21s-12.4,8.1-13.6,21c0,0,5.5,3.4,10.5-1.7c5.6-6.2,1.7-11.8,5.9-21.2c0.2-0.4-0.2-0.8-0.6-0.7C19.1,5.5,21.4,19.4,21.4,19.4s-5.5-9.7-20.9-4.7c-0.6,0.2-0.7,1-0.2,1.3c4.5,2.9,3.9,9.5,10.9,11.4c6,1.1,7.5-1.6,7.5-1.6C13.8,16.7,2.3,15.4,2.3,15.4s18.6,0.1,18.6,11.9c0,3.2,0.6,6.3,1.7,9.1c-0.2-0.1-6.2-3.4-13,4.2c-0.3,0.3-0.1,0.7,0.3,0.8c3.4,0.1,5.2,4,9.7,2.8c3.6-1.3,3.6-3.3,3.6-3.3c-5.7-3.4-12.4-0.4-12.4-0.4s9.9-5.7,13.9,0.2c4.4,6.9,12,11.4,20.8,11.4c8.6,0,16.2-4.4,20.6-11.1h3.2c1,0,1.7-0.8,1.7-1.7v-3.4c0-1.5,1.2-2.8,2.8-2.8c1,0,1.7-0.8,1.7-1.7v-0.9h0v-7.6h1.1c0.5,0,0.9-0.4,0.9-0.9v-2.8C77.7,18.6,77.3,18.2,76.8,18.2z"/>
        <path d="M54.4,7.5c0.4-1.1,1.3-1.9,2.3-2.2c-3.4-1.7-7.2-2.7-11.2-2.7c-0.4,0-0.8,0-1.2,0c-0.4,1.1-0.7,2.1-1,3.1 c0.7-0.1,1.4-0.1,2.2-0.1C48.8,5.6,51.7,6.3,54.4,7.5z"/>
    </svg>
    <div>
        <span><strong>Green Hosting:</strong></span>
        <span>Carbon Neutral Web Hosting</span>
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 233.6 65.1" width="100" style="enable-background:new 0 0 233.6 65.1;" xml:space="preserve" fill="var(--r-ghb-text)">
            <g>
                <path d="M32.5,39.9c4.1,0,7.3-3.3,7.3-7.3s-3.3-7.3-7.3-7.3h-7.3v7.3h0c0,0,0,0,0,0.1C25.2,36.6,28.5,39.9,32.5,39.9z"/>
                <path fill="var(--r-ghb-bc-primary,#FF004A)" d="M32.5,0h-7.3v10.8h7.3c12,0,21.7,9.7,21.7,21.7s-9.7,21.7-21.7,21.7c-12,0-21.7-9.7-21.7-21.7c0-0.1,0-0.1,0-0.2h0V0H0v32.2h0c0,0.1,0,0.2,0,0.3c0,18,14.6,32.5,32.5,32.5s32.5-14.6,32.5-32.5C65.1,14.6,50.5,0,32.5,0z"/>
            </g>
            <g>
                <path d="M103.4,34c0,5.6-3.4,9.4-8.5,9.4c-2.4,0-4.4-1-5.7-2.7v2.5h-5.9V17.7h5.9v9.4c1.3-1.7,3.2-2.6,5.5-2.6C99.9,24.4,103.4,28.2,103.4,34z M97.4,33.8c0-2.8-1.7-4.8-4.1-4.8c-2.4,0-4.1,2-4.1,4.8c0,2.9,1.7,4.8,4.1,4.8C95.8,38.6,97.4,36.6,97.4,33.8z"/>
                <path d="M125.2,33.9c0,5.7-4,9.5-10.1,9.5c-6.1,0-10.1-3.8-10.1-9.5s4-9.4,10.1-9.4C121.2,24.4,125.2,28.2,125.2,33.9z M111,33.9c0,2.9,1.7,4.8,4.1,4.8c2.4,0,4.1-1.9,4.1-4.8c0-2.8-1.7-4.8-4.1-4.8C112.7,29.1,111,31.1,111,33.9z"/>
                <path d="M138.8,24.6h6.5l-5.9,9l6.3,9.5h-6.8l-3.4-5.8l-3.8,5.8h-6.5l6.3-9.5l-5.9-9h6.8l3.1,5.3L138.8,24.6z"/>
                <path d="M168.8,23l-3.5,4.2c-1.6-1.9-3.9-3.1-6-3.1c-3.8,0-6.7,3-6.7,7c0,4,2.9,7.1,6.7,7.1c2,0,4.4-1.1,6-2.8l3.6,3.8c-2.6,2.6-6.4,4.4-9.9,4.4c-7.2,0-12.6-5.3-12.6-12.3c0-6.9,5.5-12.1,12.8-12.1C162.7,18.9,166.4,20.5,168.8,23z"/>
                <path d="M190.7,31.5v11.7h-5.9v-10c0-2.2-1.2-3.5-3.3-3.5c-2.3,0-3.8,1.9-3.8,4.4v9.1h-5.9V17.7h5.9v10c1.3-2.2,3.5-3.3,6.2-3.3C188,24.4,190.7,27.1,190.7,31.5z"/>
                <path d="M194.8,43.1V24.6h5.9v18.5H194.8z"/>
                <path d="M205.7,43.1V17.7h5.9v25.4H205.7z"/>
                <path d="M216.7,43.1V17.7h5.9v25.4H216.7z"/>
                <path d="M227.5,43.1V24.6h5.9v18.5H227.5z"/>
                <path fill="var(--r-ghb-bc-primary,#FF004A)" d="M200.9,19.3c0,1.9-1.3,3.2-3.1,3.2s-3.1-1.3-3.1-3.2c0-1.8,1.3-3.1,3.1-3.1S200.9,17.5,200.9,19.3z"/>
                <path fill="var(--r-ghb-bc-primary,#FF004A)" d="M233.6,19.3c0,1.9-1.3,3.2-3.1,3.2c-1.8,0-3.1-1.3-3.1-3.2c0-1.8,1.3-3.1,3.1-3.1C232.3,16.2,233.6,17.5,233.6,19.3z"/>
            </g>
        </svg>
    </div>
</a>
    <?php
}

/**
 * Output the style tag before the Raptor Frontend main CSS
 * so that properties can be overridden without `!important`
 * 
 * It is discouraged from changing anything other than the CSS
 * variables for colour schemes.
 */
function raptor_green_hosting_badge_style() {
    ?>
<style>
    .raptor-green-hosting-badge {
        --r-ghb-primary: #34a12e;
        --r-ghb-text: var( --c-black );
        --r-ghb-bc-primary: #ff004a;

        display: flex;
        gap: 16px;
    }

    .raptor-green-hosting-badge span {
        display: block;
    }
    
    .raptor-green-hosting-badge span:last-of-type {
        margin-bottom: 8px;
        padding-bottom: 6px;

        border-bottom: 2px solid var( --r-ghb-primary );
    }
</style>
    <?php
}
add_action( 'wp_head', 'raptor_green_hosting_badge_style', 5 );
