<?php

namespace Raptor\ACF;

class Flexi_Block_Library_Autoload {
    function __construct() {
        add_action( 'acf/init', [ $this, 'acf_init' ] );
        add_action( 'after_setup_theme', [ $this, 'load_functions' ] );
    }

    function acf_init() {
        foreach ( glob( __DIR__ . '/../../../../../raptor-library/flexi-block/blocks/**/acf.php' ) as $file ) {
            include_once $file;
        }
    }


    /**
     * Load anything that would typically be loaded in `functions.php`
     */
    function load_functions() {
        foreach ( glob( __DIR__ . '/../../../../../raptor-library/flexi-block/blocks/**/functions.php' ) as $file ) {
            include_once $file;
        }
    }
}

new Flexi_Block_Library_Autoload;
