<?php

use Raptor\ACF\Utils;
use Raptor\ACF\Field_Types;


Utils\add_settings_tab([
    'label' => 'Contact Details',
    'fields' => [
        Field_Types\text_field(
            'Email address',
            [
                'placeholder'   => 'info@example.com',
                'wrapper'       => [
                    'width'         => '50'
                ]
            ]
        ),
        Field_Types\text_field(
            'Phone number',
            [
                'placeholder'   => '0800 123 456',
                'wrapper'       => [
                    'width'         => '50'
                ]
            ]
        ),
        Field_Types\textarea_field(
            'Address',
            [
                'placeholder'   => 'Westminster,&#10;London,&#10;SW1A 1AA',
                'wrapper'       => [
                    'width'         => '50' 
                ],
                'rows'          => '6',
                'new_lines'     => 'br'
            ]
        ),
        Field_Types\textarea_field(
            'Opening hours',
            [
                'placeholder'   => 'Mon - Fri: 09:00 - 17:00&#10;Sat - Sun: Closed',
                'wrapper'       => [
                    'width'         => '50'
                ],
                'rows'          => '6',
                'new_lines'     => 'br'
            ]
        )
    ]
]);

if ( !in_array( 'wordpress-seo/wp-seo.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    Utils\add_settings_tab([
        'label' => 'Social Media',
        'fields' => [
            Field_Types\url_field(
                'Facebook'
            ),
            Field_Types\text_field(
                'Twitter',
                [
                    'instructions' => 'Username handle only', // Minic how Yoast is setup.
                    'prepend' => 'https://twitter.com/'
                ]
            ),
            Field_Types\url_field(
                'Instagram'
            ),
            Field_Types\url_field(
                'LinkedIn'
            ),
            Field_Types\url_field(
                'YouTube'
            ),
            Field_Types\url_field(
                'Pinterest'
            )
        ]
    ]);
}

Utils\add_settings_tab([
    'label' => 'Branding',
    'fields' => [
        Field_Types\color_picker_field(
            'Primary',
            [
                'name' => 'color_primary',
                'wrapper' => [ 'width' => '33.333333' ],
                'default_value' => '#FF014A'
            ]
        ),
        Field_Types\color_picker_field(
            'Secondary',
            [
                'name' => 'color_secondary',
                'wrapper' => [ 'width' => '33.333333' ],
                'default_value' => '#444BB0'
            ]
        ),
        Field_Types\color_picker_field(
            'White',
            [
                'name' => 'color_white',
                'wrapper' => [ 'width' => '33.333333' ],
                'default_value' => '#ffffff'
            ]
        ),
        Field_Types\color_picker_field(
            'Light Grey',
            [
                'name' => 'color_l_grey',
                'wrapper' => [ 'width' => '33.333333' ],
                'default_value' => '#F4F4F7'
            ]
        ),
        Field_Types\color_picker_field(
            'Dark Grey',
            [
                'name' => 'color_d_grey',
                'wrapper' => [ 'width' => '33.333333' ],
                'default_value' => '#333333'
            ]
        ),
        Field_Types\color_picker_field(
            'Black',
            [
                'name' => 'color_black',
                'wrapper' => [ 'width' => '33.333333' ],
                'default_value' => '#000000'
            ]
        )
    ]
]);

Utils\add_settings_tab([
    'label' => 'Tracking',
    'fields' => [
        Field_Types\wysiwyg_field(
            'Tracking head',
            [
                'key'           => 'head',
                'name'          => 'head',
                'label'         => 'Place in &lt;head&gt;',
                'tabs'          => 'text',
                'toolbar'       => 'basic',
                'media_upload'  => 0
            ]
        ),
        Field_Types\wysiwyg_field(
            'Tracking body (open)',
            [
                'key'           => 'body_open',
                'name'          => 'body_open',
                'label'         => 'Place at the start of &lt;body&gt;',
                'tabs'          => 'text',
                'toolbar'       => 'basic',
                'media_upload'  => 0
            ]
        ),
        Field_Types\wysiwyg_field(
            'Tracking body (close)',
            [
                'key'           => 'body_close',
                'name'          => 'body_close',
                'label'         => 'Place at the end of &lt;body&gt;',
                'tabs'          => 'text',
                'toolbar'       => 'basic',
                'media_upload'  => 0
            ]
        ),
        Field_Types\true_false_field(
            'Always Enabled',
            [
                'instructions' => 'The tracking codes are not loaded on staging and development sites by default, this setting will override that feature.'
            ]
        )
    ]
]);

Utils\add_settings_tab([
    'label' => 'Cookies',
    'fields' => [
        Field_Types\wysiwyg_field(
            'Message',
            [
                'key' => 'cookies_message',
                'toolbar'       => 'basic',
                'media_upload'  => 0,
                'wrapper'       => [
                    'class'         => 'mini-editor'
                ],
                'default_value' => 'This website uses cookies to ensure you get the best experience on our website.'
            ]
        )
    ]
]);

Utils\add_settings_tab([
    'label' => 'Announcement Bar',
    'fields' => [
        Field_Types\text_field(
            'Message',
            [
                'key'       => 'announcement_bar_message',
                'wrapper'   => [
                    'width'     => '60'
                ]
            ]
        ),
        Field_Types\text_field(
            'Link',
            [
                'wrapper' => [
                    'width' => '40'
                ]
            ]
        )
    ]
]);

$post_type_fields = raptor_flexi_get_available_post_types( 'post_object' );

if ( !empty( $post_type_fields ) ) {
    Utils\add_settings_tab([
        'label' => 'Page Setup',
        'fields' => $post_type_fields
    ]);
}

Utils\register_settings_group([
    'name' => 'raptor',
    'title' => 'Raptor Settings',
    'menu_title' => 'Raptor',
    'redirect' => false,
    'position' => 54,
    'show_in_graphql' => true
]);
