import ConditionalLogic from '.'

export default class SwiperConditionalLogic extends ConditionalLogic {
  /** @type {import('swiper').Swiper | undefined} */
  swiper = null

  /**
   * @param {HTMLFormElement} form
   * @param {import('swiper').Swiper | undefined} swiper
   */
  constructor(form, swiper) {
    super(form)

    this.swiper = swiper
  }

  /**
   * @returns {import('swiper').Swiper | undefined}
   */
  getSwiperInstance() {
    return this.swiper
  }


  getNextGroup() {
    /** @type {string[]} */
    const allGroups = [...this.form.querySelectorAll(
      'fieldset.swiper-slide'
    )]
      .map((fieldset) => {
        return fieldset.name
      })

    /** @type {string[]} */
    const visibleGroups = [...this.form.querySelectorAll(
      'fieldset.swiper-slide:not(.conditionally-hidden)'
    )]
      .map((fieldset) => {
        return fieldset.name
      })

    const swiper = this.getSwiperInstance()
    const groupIndex = swiper.activeIndex
    const visibleGroupIndex = visibleGroups.indexOf(allGroups[groupIndex])
    const nextGroup = visibleGroups.at(visibleGroupIndex + 1)
    const nextGroupIndex = allGroups.indexOf(nextGroup)

    if (visibleGroups.indexOf(nextGroup) >= 0) {
      if (swiper) {
        swiper.raptor.currentGroup = groupIndex
        swiper.raptor.nextGroup = nextGroup
        swiper.raptor.nextGroupIndex = nextGroupIndex
      }
    }
  }


  controlVisibility(thing, el) {
    super.controlVisibility(thing, el)

    this.getNextGroup()
  }
}
