<?php 
namespace Raptor\Forms\Field_Type;

use Raptor\Forms\Field_Type;
use Raptor\Forms\Form;

class Number extends Field_Type {
    /**
     * It'll be good to set field specific defaults here.
     */
    function __construct( array $settings, Form $form ) {
        parent::__construct( $form );

        $default_settings = array_merge(
            $this->universal_settings,
            [
                'placeholder' => '',
                'min' => '',
                'max' => ''
            ]
        );

        $this->settings = wp_parse_args( $settings, $default_settings );
    }

    function render_field() {
        if ( !empty( $this->settings['label'] ) ) {
            printf( '<label for="%s">%s</label>', $this->html_id(), $this->label() );
        }

        // Field attributes
        $attributes = $this->setup_attributes([
            'placeholder' => $this->settings['placeholder'],
            'min' => $this->settings['min'],
            'max' => $this->settings['max']
        ]);

        printf( '<input type="number" inputmode="numeric" class="form-input" %s />', raptor_output_attr( $attributes ) );
    }
}
