<?php
namespace Raptor\ACF;

use Raptor\ACF\Admin;


/**
 * Parse Flexi data to inject Global Block data.
 */
add_filter( 'wpgraphql/acf/field_value', function( $value, $acf_field, $root, $id ) {
    if ( $value && $acf_field['type'] == 'flexible_content' && preg_match( '/^flexi_blocks_builder/', $acf_field['name'] ) ) {
        $value = Admin\raptor_flexi_parse_global_blocks_data( $value, true );
        /**
         * Respect hidden blocks.
         */
        $value = array_filter( $value, function( $block ) {
            return !(bool) $block['settings']['hide'];
        });
    }

    return $value;
}, 10, 4 );


/**
 * Ensure only posts with a status of publish makes it through as the final field value.
 * 
 * @param array $return
 * @param array $value
 * @param WPGraphQL\AppContext $context
 * @param array $info
 */
add_filter( 'graphql_acf_post_object_source', function( $return, $value, $context, $info ) {
    // Immediately override with empty array and start over.
    $return = [];

    if ( !empty( $value ) ) {
        if ( is_array( $value ) ) {
            foreach ( $value as $id ) {
                $post = get_post( $id );
                if ( !empty( $post ) && $post->post_status == 'publish' ) {
                    $return[] = new \WPGraphQL\Model\Post( $post );
                }
            }
        } else {
            $post = get_post( absint( $value ) );
            if ( !empty( $post ) && $post->post_status == 'publish' ) {
                $return[] = new \WPGraphQL\Model\Post( $post );
            }
        }
    }

    return $return;
}, 10, 4 );


add_action( 'plugins_loaded', function() {
    include_once ABSPATH . 'wp-admin/includes/plugin.php';
    
    if ( !\is_plugin_active( 'wp-graphql-acf/wp-graphql-acf.php' ) ) {
        return;
    }

    require_once RAPTOR_ACF . 'graphql-flexi-block-field.php';

    $flexi_blocks_field = new GraphQL_Flexi_Blocks();

    add_action( 'graphql_register_types', [ $flexi_blocks_field, 'init' ] );
});


add_filter( 'wpgraphql/acf/field_value', function( $value, $acf_field, $root, $id ) {
    if ( $id == 'flexi_preview' ) {
        if ( isset( $acf_field['parent_layout'] ) ) {
            global $raptor_blocks_library;

            $field_name = $acf_field['name'];

            if ( isset( $root['global_id'] ) && $root['global_id'] ) {
                $global_id = $root['global_id'];

                $block_data = raptor_setup_flexi_block_data( $global_id );

                if ( isset( $block_data[ $field_name ] ) ) {
                    return $block_data[ $field_name ];
                }
            }

            $block_name = preg_replace( '/^layout_block__/', '', $acf_field['parent_layout'] );
            $block = isset( $raptor_blocks_library[ $block_name ] ) ? $raptor_blocks_library[ $block_name ] : null;

            if ( $block ) {
                $example_fields = $block->example['fields'];

                if ( isset( $example_fields[ $field_name ] ) ) {
                    return $example_fields[ $field_name ];
                }
            }
        }
    }

    return $value;
}, 10, 4 );


add_filter( 'graphql_acf_get_root_id', function( $id, $root ) {
    if ( empty( $id ) && isset( $root['flexi_preview'] ) ) {
        $id = 'flexi_preview';
    }

    return $id;
}, 10, 2 );
