<?php

use Raptor\ACF\Utils;
use Raptor\ACF\Field_Types;


Utils\add_settings_tab([
    'group' => 'forms',
    'label' => 'Mail',
    'fields' => [
        Field_Types\text_field(
            'Recipients',
            [
                'default_value' => get_bloginfo( 'admin_email' ),
                'instructions' => "Choose email addresses to send contact form submissions to. <br> You can add multiple by seperating with a comma.",
                'required' => true
            ]
        ),
        Field_Types\text_field(
            'CC',
            [
                'instructions' => 'Choose email addresses to CC into emails.'
            ]
        ),
        Field_Types\text_field(
            'BCC',
            [
                'instructions' => 'Choose email addresses to BCC into emails.'
            ]
        ),
        Field_Types\text_field(
            'Subject',
            [
                'default_value' => 'New Enquiry via Website',
                'required' => true,
                'instructions' => 'The subject line used in the email when a submission is made.'
            ]
        ),
    ]
]);

Utils\add_settings_tab([
    'group' => 'forms',
    'label' => 'Submissions',
    'fields' => [
        Field_Types\button_group_field(
            'Capture',
            [
                'choices' => [
                    'never' => 'Never',
                    'success_only' => 'Success Only',
                    'always' => 'Always',
                ],
                'default_value' => 'success_only',
                'instructions' => 'When should submissions be stored to the database?'
            ]
        )
    ]
]);

Utils\add_settings_tab([
    'group' => 'forms',
    'label' => 'Success Message',
    'fields' => [
        Field_Types\text_field(
            'Heading',
            [
                'default_value' => 'Thank you!'
            ]
        ),
        Field_Types\textarea_field(
            'Body',
            [
                'default_value' => 'One of the team will be in touch soon.'
            ]
        )
    ],
    'group_args' => [
        'instructions' => 'The default message shown when a contact form submitted successfully.'
    ]
]);

Utils\add_settings_tab([
    'group' => 'forms',
    'label' => 'Error Message',
    'fields' => [
        Field_Types\text_field(
            'Heading',
            [
                'default_value' => 'Error!'
            ]
        ),
        Field_Types\textarea_field(
            'Body',
            [
                'default_value' => 'We were unable to process your message at this time. Please try again.',
                'instructions' => 'May be overridden depending on the error code.'
            ]
        )
    ],
    'group_args' => [
        'instructions' => 'The default message shown when an error occured trying to submit a contact form.'
    ]
]);

Utils\add_settings_tab([
    'group' => 'forms',
    'label' => 'reCAPTCHA',
    'fields' => [
        Field_Types\text_field( 'Site Key' ),
        Field_Types\password_field( 'Secret Key' )
    ],
    'group_args' => [
        'instructions' => 'Raptor uses <a href="https://developers.google.com/recaptcha/docs/v3" target="blank" rel="noopener noreferrer">Google reCAPTCHA v3</a> to help protect this site from fraudulent activities, spam, and abuse.'
    ]
]);

// Add mailchimp api fields if not headless
if ( !defined( 'RAPTOR_HEADLESS_FRONTEND_URL' ) ) {
    Utils\add_settings_tab([
        'group' => 'forms',
        'label' => 'API Keys',
        'fields' => [
            Field_Types\text_field( 
                'Mailchimp API Key',
                [
                    'instructions' => 'The api key for Mailchimp API. This is used to post form submissions to Mailchimp audience lists.',
                    'required' => false,
                ]
            ),
            Field_Types\text_field( 
                'Mailchimp Region Prefix',
                [
                    'instructions' => 'The region prefix for Mailchimp API. E.g. us1, us2, etc. This is used to build the api url. This will be the final part of the api key.',
                    'required' => true,
                    'conditional_logic' => [
                        [
                            'field' => 'api_keys_mailchimp_api_key',
                            'operator' => '!=empty',
                        ],
                    ],
                ]
            ),
            Field_Types\text_field( 
                'Mailchimp List ID',
                [
                    'instructions' => 'The list ID for Mailchimp API. This is the list ID you will be posting to.',
                    'required' => true,
                    'conditional_logic' => [
                        [
                            'field' => 'api_keys_mailchimp_api_key',
                            'operator' => '!=empty',
                        ],
                    ]
                ]
            ),
        ],
        'group_args' => [
            'instructions' => 'Api credentials for third party services.'
        ],
    ]);
}

Utils\register_settings_group([
    'name' => 'forms',
    'title' => 'Form Settings',
    'menu_title' => 'Settings',
    'parent_slug' => 'edit.php?post_type=raptor_form'
]);
